% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022
%
%% Compute the transition matrix across states

lenk    = PARMS.N; % length of K grid is the same as EPS grid

trans   = zeros(lenk*PARMS.N); 

idx     = [PARMS.N, lenk]; % for indexing

for ee = 1:PARMS.N % EPS today
    for kk = 1:lenk % K today after reallocation
        
        today           = (kk-1)*lenk + ee;         
        
        % Non-adjusters --> same capital, but any of the eps levels
        tomorrow                        = (kk-1)*lenk + (1:PARMS.N);
        
        trans(today,tomorrow)           = PARMS.prob_rho(ee,:) * (1-pistar);

        % Adjusters
        tomorrow                        = ((1:lenk)-1)*lenk + (1:PARMS.N);                
        % Probability from ee to go to each ee'
        trans(today,tomorrow)           = trans(today,tomorrow) + PARMS.prob_rho(ee,:)* pistar;
                
    end
end

%% Stationary distribution
probst      = ones(PARMS.N*lenk,1)/(PARMS.N*lenk);
errx = 1;
while errx > 1e-08
    probst1 = trans'*probst + 0;
    errx = max(abs(probst1-probst));
    probst = probst1;
end

dist = reshape(probst,PARMS.N,lenk);

%% Transition matrix conditional on not adjusting (needed in simulation)

trans_nopi      = zeros(lenk*PARMS.N); 

for ee = 1:PARMS.N % EPS today
    for kk = 1:lenk % K today after reallocation
        
        today           = (kk-1)*lenk + ee; 
        tomorrow                        = (kk-1)*lenk + (1:PARMS.N);
        trans_nopi(today,tomorrow)      = PARMS.prob_rho(ee,:); 
                
    end
end

%% Transition matrix conditional on adjusting (needed in simulation)

trans_pi    = zeros(PARMS.N^2);

for ee = 1:PARMS.N % EPS today
    for kk = 1:lenk % K today after reallocation

        today           = (kk-1)*lenk + ee;
        tomorrow                        = ((1:lenk)-1)*lenk + (1:PARMS.N);
        trans_pi(today,tomorrow)           = PARMS.prob_rho(ee,:) * 1;
        
    end
end
